/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.CheckList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableMapImpl;
import com.floragunn.fluent.collections.ImmutableSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public interface CheckTable<R, C> {
    public static final CheckTable<?, ?> EMPTY = new CheckTable<Object, Object>(){

        @Override
        public boolean check(Object row, Object column) {
            return false;
        }

        @Override
        public boolean checkIf(Object row, Predicate<Object> columnCheckPredicate) {
            return false;
        }

        @Override
        public boolean checkIf(Iterable<Object> rows, Predicate<Object> columnCheckPredicate) {
            return false;
        }

        @Override
        public void uncheckIf(Object row, Predicate<Object> columnCheckPredicate) {
        }

        @Override
        public void uncheckIf(Iterable<Object> rows, Predicate<Object> columnCheckPredicate) {
        }

        @Override
        public void uncheckIf(Predicate<Object> rowCheckPredicate, Object column) {
        }

        @Override
        public void uncheckIf(Predicate<Object> rowCheckPredicate, Iterable<Object> columns) {
        }

        @Override
        public boolean isChecked(Object row, Object column) {
            return false;
        }

        @Override
        public boolean isComplete() {
            return false;
        }

        @Override
        public boolean isBlank() {
            return false;
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return "-/-";
        }

        @Override
        public String toTableString() {
            return "-/-";
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            return "-/-";
        }

        @Override
        public ImmutableSet<Object> getCompleteRows() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Object> getCompleteColumns() {
            return ImmutableSet.empty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ImmutableSet<Object> getRows() {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Object> getColumns() {
            return ImmutableSet.empty();
        }

        @Override
        public void uncheckAll() {
        }

        @Override
        public void uncheckRowIf(Predicate<Object> rowCheckPredicate) {
        }

        @Override
        public void uncheckRow(Object row) {
        }

        @Override
        public void uncheckRowIfPresent(Object row) {
        }

        @Override
        public boolean checkIf(Predicate<Object> rowCheckPredicate, Object column) {
            return false;
        }

        @Override
        public Iterable<Object> iterateUncheckedRows(Object column) {
            return ImmutableSet.empty();
        }

        @Override
        public Iterable<Object> iterateUncheckedColumns(Object row) {
            return ImmutableSet.empty();
        }

        @Override
        public void uncheck(Object row, Object column) {
        }

        @Override
        public Iterable<Object> iterateCheckedRows(Object column) {
            return ImmutableSet.empty();
        }

        @Override
        public Iterable<Object> iterateCheckedColumns(Object row) {
            return ImmutableSet.empty();
        }
    };

    public static <R, C> CheckTable<R, C> create(R row, Set<C> columns) {
        if (columns.size() == 0) {
            throw new RuntimeException("Trying to create empty CheckTable: " + columns);
        }
        if (columns.size() == 1) {
            return new SingleCellCheckTable<R, C>(row, columns.iterator().next(), ImmutableSet.of(row), ImmutableSet.of(columns));
        }
        return new SingleRowCheckTable<R, C>(row, columns);
    }

    public static <R, C> CheckTable<R, C> create(Set<R> rows, C column) {
        if (rows.size() == 0) {
            throw new RuntimeException("Trying to create empty CheckTable: " + rows);
        }
        if (rows.size() == 1) {
            return new SingleCellCheckTable<R, C>(rows.iterator().next(), column, ImmutableSet.of(rows), ImmutableSet.of(column));
        }
        return new SingleColumnCheckTable<R, C>(rows, column);
    }

    public static <R, C> CheckTable<R, C> create(Set<R> rows, Set<C> columns) {
        if (rows.size() == 0 || columns.size() == 0) {
            throw new RuntimeException("Trying to create empty CheckTable: " + rows + " " + columns);
        }
        if (rows.size() == 1) {
            if (columns.size() == 1) {
                return new SingleCellCheckTable<R, C>(rows.iterator().next(), columns.iterator().next(), ImmutableSet.of(rows), ImmutableSet.of(columns));
            }
            return new SingleRowCheckTable<R, C>(rows.iterator().next(), columns);
        }
        if (columns.size() == 1) {
            return new SingleColumnCheckTable<R, C>(rows, columns.iterator().next());
        }
        if (columns.size() == 2) {
            Iterator<C> iter = columns.iterator();
            return new TwoColumnCheckTable<R, C>(rows, iter.next(), iter.next());
        }
        return new ArrayCheckTable<R, C>(rows, columns);
    }

    public static <R, C> CheckTable<R, C> empty() {
        return EMPTY;
    }

    public boolean check(R var1, C var2);

    public boolean checkIf(R var1, Predicate<C> var2);

    public boolean checkIf(Iterable<R> var1, Predicate<C> var2);

    public boolean checkIf(Predicate<R> var1, C var2);

    public void uncheck(R var1, C var2);

    public void uncheckIf(R var1, Predicate<C> var2);

    public void uncheckIf(Iterable<R> var1, Predicate<C> var2);

    public void uncheckIf(Predicate<R> var1, C var2);

    public void uncheckIf(Predicate<R> var1, Iterable<C> var2);

    public void uncheckRowIf(Predicate<R> var1);

    public void uncheckRow(R var1);

    public void uncheckRowIfPresent(R var1);

    public void uncheckAll();

    public boolean isChecked(R var1, C var2);

    public boolean isComplete();

    public boolean isBlank();

    public String toString(String var1, String var2);

    public String toTableString();

    public String toTableString(String var1, String var2);

    public ImmutableSet<R> getRows();

    public ImmutableSet<C> getColumns();

    public ImmutableSet<R> getCompleteRows();

    public ImmutableSet<C> getCompleteColumns();

    public Iterable<R> iterateCheckedRows(C var1);

    public Iterable<C> iterateCheckedColumns(R var1);

    public Iterable<R> iterateUncheckedRows(C var1);

    public Iterable<C> iterateUncheckedColumns(R var1);

    public boolean isEmpty();

    public static String padEnd(String string, int width, char paddingChar) {
        if (string.length() > width) {
            return string;
        }
        StringBuilder result = new StringBuilder(string);
        while (result.length() < width) {
            result.append(paddingChar);
        }
        return result.toString();
    }

    public static abstract class AbstractCheckTable<R, C>
    implements CheckTable<R, C> {
        static final int STRING_TABLE_HEADER_WIDTH = 40;

        @Override
        public boolean checkIf(Iterable<R> rows, Predicate<C> columnCheckPredicate) {
            for (R row : rows) {
                if (!this.checkIf(row, columnCheckPredicate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void uncheckIf(Iterable<R> rows, Predicate<C> columnCheckPredicate) {
            if (this.isBlank()) {
                return;
            }
            for (R row : rows) {
                this.uncheckIf(row, columnCheckPredicate);
                if (!this.isBlank()) continue;
                return;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, Iterable<C> columns) {
            if (this.isBlank()) {
                return;
            }
            for (C column : columns) {
                this.uncheckIf(rowCheckPredicate, column);
                if (!this.isBlank()) continue;
                return;
            }
        }

        public String toString() {
            return this.toString("x", "");
        }

        @Override
        public String toTableString() {
            return this.toTableString("x", "");
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.toTableString(checkedIndicator, uncheckedIndicator);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        static <T> ImmutableMap<T, Integer> createIndexMap(Set<T> set) {
            int size = set.size();
            if (size == 2) {
                Iterator<T> iter = set.iterator();
                return new ImmutableMapImpl.TwoElementMap<T, Integer>(iter.next(), 0, iter.next(), 1);
            }
            int i = 0;
            LinkedHashMap<T, Integer> result = new LinkedHashMap<T, Integer>(set.size());
            for (T e : set) {
                result.put(e, i);
                ++i;
            }
            return new ImmutableMapImpl.MapBackedMap(result);
        }
    }

    public static class ArrayCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private ImmutableMap<R, Integer> rows;
        private ImmutableMap<C, Integer> columns;
        private ImmutableSet<R> rowKeys;
        private ImmutableSet<C> columnKeys;
        private boolean[][] table;
        private int checkedCount = 0;
        private int uncheckedCount;
        private final int size;

        ArrayCheckTable(Set<R> rows, Set<C> columns) {
            this.rows = ArrayCheckTable.createIndexMap(rows);
            this.columns = ArrayCheckTable.createIndexMap(columns);
            this.rowKeys = ImmutableSet.of(rows);
            this.columnKeys = ImmutableSet.of(columns);
            this.table = new boolean[this.rows.size()][this.columns.size()];
            this.uncheckedCount = this.size = this.rows.size() * this.columns.size();
        }

        @Override
        public boolean check(R row, C column) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (!this.table[rowIndex][columnIndex]) {
                this.table[rowIndex.intValue()][columnIndex.intValue()] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public void uncheck(R row, C column) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.table[rowIndex][columnIndex]) {
                this.table[rowIndex.intValue()][columnIndex.intValue()] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
            }
        }

        @Override
        public void uncheckAll() {
            this.checkedCount = 0;
            this.uncheckedCount = this.size;
            for (int i = 0; i < this.rows.size(); ++i) {
                Arrays.fill(this.table[i], false);
            }
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (this.isBlank()) {
                return;
            }
            for (Map.Entry entry : this.rows.entrySet()) {
                if (!rowCheckPredicate.test(entry.getKey())) continue;
                for (int i = 0; i < this.table[(Integer)entry.getValue()].length; ++i) {
                    if (!this.table[(Integer)entry.getValue()][i]) continue;
                    this.table[((Integer)entry.getValue()).intValue()][i] = false;
                    --this.checkedCount;
                    ++this.uncheckedCount;
                    if (this.checkedCount != 0) continue;
                    return;
                }
            }
        }

        @Override
        public void uncheckRow(R row) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.isBlank()) {
                return;
            }
            for (int i = 0; i < this.table[rowIndex].length; ++i) {
                if (!this.table[rowIndex][i]) continue;
                this.table[rowIndex.intValue()][i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                return;
            }
            if (this.isBlank()) {
                return;
            }
            for (int i = 0; i < this.table[rowIndex].length; ++i) {
                if (!this.table[rowIndex][i]) continue;
                this.table[rowIndex.intValue()][i] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public boolean isComplete() {
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean isBlank() {
            return this.checkedCount == 0;
        }

        @Override
        public boolean isChecked(R row, C column) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.table[rowIndex][columnIndex];
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            for (Map.Entry entry : this.columns.entrySet()) {
                if (this.table[rowIndex][(Integer)entry.getValue()] || !columnCheckPredicate.test(entry.getKey())) continue;
                this.table[rowIndex.intValue()][((Integer)entry.getValue()).intValue()] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
                if (this.uncheckedCount != 0) continue;
                return true;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            for (Map.Entry entry : this.rows.entrySet()) {
                if (this.table[(Integer)entry.getValue()][columnIndex] || !rowCheckPredicate.test(entry.getKey())) continue;
                this.table[((Integer)entry.getValue()).intValue()][columnIndex.intValue()] = true;
                ++this.checkedCount;
                --this.uncheckedCount;
                if (this.uncheckedCount != 0) continue;
                return true;
            }
            return this.uncheckedCount == 0;
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.uncheckedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rowKeys.iterateMatching(row -> !this.table[(Integer)this.rows.get(row)][columnIndex]);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.uncheckedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columnKeys.iterateMatching(column -> !this.table[rowIndex][(Integer)this.columns.get(column)]);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.uncheckedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rowKeys.iterateMatching(row -> this.table[(Integer)this.rows.get(row)][columnIndex]);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.uncheckedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columnKeys.iterateMatching(column -> this.table[rowIndex][(Integer)this.columns.get(column)]);
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checkedCount == 0) {
                return;
            }
            for (Map.Entry entry : this.columns.entrySet()) {
                if (!this.table[rowIndex][(Integer)entry.getValue()] || !columnCheckPredicate.test(entry.getKey())) continue;
                this.table[rowIndex.intValue()][((Integer)entry.getValue()).intValue()] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checkedCount == 0) {
                return;
            }
            for (Map.Entry entry : this.rows.entrySet()) {
                if (!this.table[(Integer)entry.getValue()][columnIndex] || !rowCheckPredicate.test(entry.getKey())) continue;
                this.table[((Integer)entry.getValue()).intValue()][columnIndex.intValue()] = false;
                --this.checkedCount;
                ++this.uncheckedCount;
                if (this.checkedCount != 0) continue;
                return;
            }
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.rows.keySet().stream().map(r -> r.toString().length()).max(Comparator.naturalOrder()).get();
            result.append(CheckTable.padEnd("", rowHeaderWidth, ' '));
            result.append("|");
            int[] columnWidth = new int[this.columns.size()];
            int i = 0;
            for (Object column : this.columns.keySet()) {
                String columnLabel = column.toString();
                if (columnLabel.length() > 40) {
                    columnLabel = columnLabel.substring(0, 40);
                }
                columnWidth[i] = columnLabel.length();
                ++i;
                result.append(" ").append(columnLabel).append(" |");
            }
            result.append("\n");
            for (Object row : this.rows.keySet()) {
                result.append(CheckTable.padEnd(row.toString(), rowHeaderWidth, ' '));
                result.append("|");
                i = 0;
                for (Object column : this.columns.keySet()) {
                    String v = this.isChecked(row, column) ? checkedIndicator : uncheckedIndicator;
                    result.append(" ").append(CheckTable.padEnd(v, columnWidth[i], ' ')).append(" |");
                    ++i;
                }
                result.append("\n");
            }
            return result.toString();
        }

        @Override
        public ImmutableSet<R> getCompleteRows() {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.rows.entrySet()) {
                int index = (Integer)entry.getValue();
                if (!this.isRowCompleted(index)) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        @Override
        public ImmutableSet<C> getCompleteColumns() {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.columns.entrySet()) {
                int index = (Integer)entry.getValue();
                if (!this.isColumnCompleted(index)) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        public ImmutableSet<R> getNonEmptyRows() {
            if (this.checkedCount == 0) {
                return ImmutableSet.empty();
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.rows.entrySet()) {
                int index = (Integer)entry.getValue();
                if (!this.isRowNonEmpty(index)) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        public ImmutableSet<C> getNonEmptyColumns() {
            if (this.checkedCount == 0) {
                return ImmutableSet.empty();
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.columns.entrySet()) {
                int index = (Integer)entry.getValue();
                if (!this.isColumnNonEmpty(index)) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        public ImmutableSet<R> getCheckedRows(C column) {
            if (this.checkedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer columnIndex = (Integer)this.columns.get(column);
            if (columnIndex == null) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.rows.entrySet()) {
                int rowIndex = (Integer)entry.getValue();
                if (!this.table[rowIndex][columnIndex]) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        public ImmutableSet<C> getCheckedColumns(R row) {
            if (this.checkedCount == 0) {
                return ImmutableSet.empty();
            }
            Integer rowIndex = (Integer)this.rows.get(row);
            if (rowIndex == null) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (Map.Entry entry : this.columns.entrySet()) {
                int columnIndex = (Integer)entry.getValue();
                if (!this.table[rowIndex][columnIndex]) continue;
                result.with(entry.getKey());
            }
            return result.build();
        }

        private boolean isRowCompleted(int row) {
            int columnCount = this.columns.size();
            for (int i = 0; i < columnCount; ++i) {
                if (this.table[row][i]) continue;
                return false;
            }
            return true;
        }

        private boolean isColumnCompleted(int column) {
            int rowCount = this.rows.size();
            for (int i = 0; i < rowCount; ++i) {
                if (this.table[i][column]) continue;
                return false;
            }
            return true;
        }

        private boolean isRowNonEmpty(int row) {
            int columnCount = this.columns.size();
            for (int i = 0; i < columnCount; ++i) {
                if (!this.table[row][i]) continue;
                return true;
            }
            return false;
        }

        private boolean isColumnNonEmpty(int column) {
            int rowCount = this.rows.size();
            for (int i = 0; i < rowCount; ++i) {
                if (!this.table[i][column]) continue;
                return true;
            }
            return false;
        }

        @Override
        public ImmutableSet<R> getRows() {
            return ImmutableSet.of(this.rows.keySet());
        }

        @Override
        public ImmutableSet<C> getColumns() {
            return ImmutableSet.of(this.columns.keySet());
        }
    }

    public static class TwoColumnCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final C column1;
        private final C column2;
        private final CheckList<R> rows1;
        private final CheckList<R> rows2;

        TwoColumnCheckTable(Set<R> rows, C column1, C column2) {
            this.column1 = column1;
            this.column2 = column2;
            this.rows1 = CheckList.create(rows, "row");
            this.rows2 = CheckList.create(rows, "row");
        }

        @Override
        public boolean check(R row, C column) {
            if (column.equals(this.column1)) {
                if (this.rows1.check(row)) {
                    return this.isComplete();
                }
                return false;
            }
            if (column.equals(this.column2)) {
                if (this.rows2.check(row)) {
                    return this.isComplete();
                }
                return false;
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public void uncheck(R row, C column) {
            if (column.equals(this.column1)) {
                this.rows1.uncheck(row);
            } else if (column.equals(this.column2)) {
                this.rows2.uncheck(row);
            } else {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (!this.rows1.isChecked(row) && columnCheckPredicate.test(this.column1)) {
                this.rows1.check(row);
            }
            if (!this.rows2.isChecked(row) && columnCheckPredicate.test(this.column2)) {
                this.rows2.check(row);
            }
            return this.isComplete();
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (column.equals(this.column1)) {
                this.rows1.checkIf(rowCheckPredicate);
            } else if (column.equals(this.column2)) {
                this.rows2.checkIf(rowCheckPredicate);
            } else {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.isComplete();
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (this.rows1.isChecked(row) && columnCheckPredicate.test(this.column1)) {
                this.rows1.uncheck(row);
            }
            if (this.rows2.isChecked(row) && columnCheckPredicate.test(this.column2)) {
                this.rows2.uncheck(row);
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (column.equals(this.column1)) {
                this.rows1.uncheckIf(rowCheckPredicate);
            } else if (column.equals(this.column2)) {
                this.rows2.uncheckIf(rowCheckPredicate);
            } else {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (column.equals(this.column1)) {
                return this.rows1.isChecked(row);
            }
            if (column.equals(this.column2)) {
                return this.rows2.isChecked(row);
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.rows1.getElements().stream().map(r -> r.toString().length()).max(Comparator.naturalOrder()).get();
            result.append(CheckTable.padEnd("", rowHeaderWidth, ' '));
            result.append("|");
            String column1Label = this.column1.toString();
            int column1Width = column1Label.length();
            result.append(" ").append(column1Label).append(" |");
            String column2Label = this.column2.toString();
            int column2Width = column2Label.length();
            result.append(" ").append(column2Label).append(" |");
            result.append("\n");
            for (Object row : this.rows1.getElements()) {
                result.append(CheckTable.padEnd(row.toString(), rowHeaderWidth, ' '));
                result.append("|");
                String v = this.rows1.isChecked(row) ? checkedIndicator : uncheckedIndicator;
                result.append(" ").append(CheckTable.padEnd(v, column1Width, ' ')).append(" |");
                v = this.rows2.isChecked(row) ? checkedIndicator : uncheckedIndicator;
                result.append(" ").append(CheckTable.padEnd(v, column2Width, ' ')).append(" |\n");
            }
            return result.toString();
        }

        @Override
        public boolean isComplete() {
            return this.rows1.isComplete() && this.rows2.isComplete();
        }

        @Override
        public boolean isBlank() {
            return this.rows1.isBlank() && this.rows2.isBlank();
        }

        @Override
        public ImmutableSet<R> getCompleteRows() {
            return this.rows1.getCheckedElements().intersection(this.rows2.getCheckedElements());
        }

        @Override
        public ImmutableSet<C> getCompleteColumns() {
            if (this.rows1.isComplete()) {
                if (this.rows2.isComplete()) {
                    return ImmutableSet.of(this.column1, this.column2);
                }
                return ImmutableSet.of(this.column1);
            }
            if (this.rows2.isComplete()) {
                return ImmutableSet.of(this.column2);
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<R> getRows() {
            return this.rows1.getElements();
        }

        @Override
        public ImmutableSet<C> getColumns() {
            return ImmutableSet.of(this.column1, this.column2);
        }

        @Override
        public void uncheckAll() {
            this.rows1.uncheckAll();
            this.rows2.uncheckAll();
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            this.rows1.uncheckIf(rowCheckPredicate);
            this.rows2.uncheckIf(rowCheckPredicate);
        }

        @Override
        public void uncheckRow(R row) {
            this.rows1.uncheck(row);
            this.rows2.uncheck(row);
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            this.rows1.uncheckIfPresent(row);
            this.rows2.uncheckIfPresent(row);
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.column1.equals(column)) {
                return this.rows1.iterateUncheckedElements();
            }
            if (this.column2.equals(column)) {
                return this.rows2.iterateUncheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.rows1.isChecked(row)) {
                if (this.rows2.isChecked(row)) {
                    return ImmutableSet.empty();
                }
                return ImmutableSet.of(this.column2);
            }
            if (this.rows2.isChecked(row)) {
                return ImmutableSet.of(this.column1);
            }
            return ImmutableSet.of(this.column1, this.column2);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.column1.equals(column)) {
                return this.rows1.iterateCheckedElements();
            }
            if (this.column2.equals(column)) {
                return this.rows2.iterateCheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.rows1.isChecked(row)) {
                if (this.rows2.isChecked(row)) {
                    return ImmutableSet.of(this.column1, this.column2);
                }
                return ImmutableSet.of(this.column1);
            }
            if (this.rows2.isChecked(row)) {
                return ImmutableSet.of(this.column2);
            }
            return ImmutableSet.empty();
        }
    }

    public static class SingleColumnCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private C column;
        private CheckList<R> rows;

        SingleColumnCheckTable(Set<R> rows, C column) {
            this.column = column;
            this.rows = CheckList.create(rows, "row");
        }

        @Override
        public boolean check(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.check(row);
        }

        @Override
        public void uncheck(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            this.rows.uncheck(row);
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (columnCheckPredicate.test(this.column)) {
                return this.rows.check(row);
            }
            return this.isComplete();
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.checkIf(rowCheckPredicate);
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (columnCheckPredicate.test(this.column)) {
                this.rows.uncheck(row);
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            this.rows.uncheckIf(rowCheckPredicate);
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.rows.isChecked(row);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.rows.getElements().stream().map(r -> r.toString().length()).max(Comparator.naturalOrder()).get();
            result.append(CheckTable.padEnd("", rowHeaderWidth, ' '));
            result.append("|");
            String columnLabel = this.column.toString();
            int columnWidth = columnLabel.length();
            result.append(" ").append(columnLabel).append(" |");
            result.append("\n");
            for (Object row : this.rows.getElements()) {
                result.append(CheckTable.padEnd(row.toString(), rowHeaderWidth, ' '));
                result.append("|");
                String v = this.rows.isChecked(row) ? checkedIndicator : uncheckedIndicator;
                result.append(" ").append(CheckTable.padEnd(v, columnWidth, ' ')).append(" |\n");
            }
            return result.toString();
        }

        @Override
        public boolean isComplete() {
            return this.rows.isComplete();
        }

        @Override
        public boolean isBlank() {
            return this.rows.isBlank();
        }

        @Override
        public ImmutableSet<R> getCompleteRows() {
            return this.rows.getCheckedElements();
        }

        @Override
        public ImmutableSet<C> getCompleteColumns() {
            if (this.isComplete()) {
                return ImmutableSet.of(this.column);
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<R> getRows() {
            return this.rows.getElements();
        }

        @Override
        public ImmutableSet<C> getColumns() {
            return ImmutableSet.of(this.column);
        }

        @Override
        public void uncheckAll() {
            this.rows.uncheckAll();
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            this.rows.uncheckIf(rowCheckPredicate);
        }

        @Override
        public void uncheckRow(R row) {
            this.rows.uncheck(row);
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            this.rows.uncheckIfPresent(row);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.column.equals(column)) {
                return this.rows.iterateCheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.rows.isChecked(row)) {
                return ImmutableSet.of(this.column);
            }
            return ImmutableSet.empty();
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.column.equals(column)) {
                return this.rows.iterateUncheckedElements();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.rows.isChecked(row)) {
                return ImmutableSet.empty();
            }
            return ImmutableSet.of(this.column);
        }
    }

    public static class SingleRowCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final R row;
        private final CheckList<C> columns;

        SingleRowCheckTable(R row, Set<C> columns) {
            this.row = row;
            this.columns = CheckList.create(columns, "column");
        }

        @Override
        public boolean check(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.check(column);
        }

        @Override
        public void uncheck(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheck(column);
        }

        @Override
        public boolean isComplete() {
            return this.columns.isComplete();
        }

        @Override
        public boolean isBlank() {
            return this.columns.isBlank();
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.checkIf(columnCheckPredicate);
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (!rowCheckPredicate.test(this.row)) {
                return false;
            }
            return this.columns.check(column);
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheckIf(columnCheckPredicate);
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (rowCheckPredicate.test(this.row)) {
                this.columns.uncheck(column);
            }
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            return this.columns.isChecked(column);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.row.toString().length() + 1;
            result.append(CheckTable.padEnd("", rowHeaderWidth, ' '));
            result.append("|");
            int[] columnWidth = new int[this.columns.size()];
            int i = 0;
            for (Object column : this.columns.getElements()) {
                String columnLabel = column.toString();
                if (columnLabel.length() > 40) {
                    columnLabel = columnLabel.substring(0, 40);
                }
                columnWidth[i] = columnLabel.length();
                ++i;
                result.append(" ").append(columnLabel).append(" |");
            }
            result.append("\n");
            result.append(this.row.toString());
            result.append(" |");
            i = 0;
            for (Object column : this.columns.getElements()) {
                String v = this.columns.isChecked(column) ? checkedIndicator : uncheckedIndicator;
                result.append(" ").append(CheckTable.padEnd(v, columnWidth[i], ' ')).append(" |");
                ++i;
            }
            return result.toString();
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.toTableString(checkedIndicator, uncheckedIndicator);
        }

        @Override
        public ImmutableSet<R> getCompleteRows() {
            if (this.isComplete()) {
                return ImmutableSet.of(this.row);
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<C> getCompleteColumns() {
            return this.columns.getCheckedElements();
        }

        @Override
        public ImmutableSet<R> getRows() {
            return ImmutableSet.of(this.row);
        }

        @Override
        public ImmutableSet<C> getColumns() {
            return this.columns.getElements();
        }

        @Override
        public void uncheckAll() {
            this.columns.uncheckAll();
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (rowCheckPredicate.test(this.row)) {
                this.columns.uncheckAll();
            }
        }

        @Override
        public void uncheckRow(R row) {
            if (!this.row.equals(row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.columns.uncheckAll();
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            if (this.row.equals(row)) {
                this.columns.uncheckAll();
            }
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.columns.isChecked(column)) {
                return ImmutableSet.empty();
            }
            return ImmutableSet.of(this.row);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.row.equals(row)) {
                return this.columns.iterateUncheckedElements();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.columns.isChecked(column)) {
                return ImmutableSet.of(this.row);
            }
            return ImmutableSet.empty();
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.row.equals(row)) {
                return this.columns.iterateCheckedElements();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }
    }

    public static class SingleCellCheckTable<R, C>
    extends AbstractCheckTable<R, C> {
        private final R row;
        private final C column;
        private final ImmutableSet<R> rowSet;
        private final ImmutableSet<C> columnSet;
        private boolean checked = false;

        SingleCellCheckTable(R row, C column, ImmutableSet<R> rowSet, ImmutableSet<C> columnSet) {
            this.row = row;
            this.column = column;
            this.rowSet = rowSet;
            this.columnSet = columnSet;
        }

        @Override
        public boolean check(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (!this.checked) {
                this.checked = true;
            }
            return this.checked;
        }

        @Override
        public void uncheck(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked) {
                this.checked = false;
            }
        }

        @Override
        public boolean isComplete() {
            return this.checked;
        }

        @Override
        public boolean isBlank() {
            return !this.checked;
        }

        @Override
        public boolean checkIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checked) {
                return true;
            }
            if (columnCheckPredicate.test(this.column)) {
                this.checked = true;
            }
            return this.checked;
        }

        @Override
        public boolean checkIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked) {
                return true;
            }
            if (rowCheckPredicate.test(this.row)) {
                this.checked = true;
            }
            return this.checked;
        }

        @Override
        public void uncheckIf(R row, Predicate<C> columnCheckPredicate) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (this.checked && columnCheckPredicate.test(this.column)) {
                this.checked = false;
            }
        }

        @Override
        public void uncheckIf(Predicate<R> rowCheckPredicate, C column) {
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            if (this.checked && rowCheckPredicate.test(this.row)) {
                this.checked = false;
            }
        }

        @Override
        public boolean isChecked(R row, C column) {
            if (!row.equals(this.row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            if (!column.equals(this.column)) {
                throw new IllegalArgumentException("Invalid column: " + column);
            }
            return this.checked;
        }

        @Override
        public String toString(String checkedIndicator, String uncheckedIndicator) {
            return this.row + "/" + this.column + ": " + (this.checked ? checkedIndicator : uncheckedIndicator);
        }

        @Override
        public String toTableString(String checkedIndicator, String uncheckedIndicator) {
            StringBuilder result = new StringBuilder();
            int rowHeaderWidth = this.row.toString().length() + 1;
            result.append(CheckTable.padEnd("", rowHeaderWidth, ' '));
            result.append("|");
            String columnLabel = this.column.toString();
            if (columnLabel.length() > 40) {
                columnLabel = columnLabel.substring(0, 40);
            }
            int columnWidth = columnLabel.length();
            result.append(" ").append(columnLabel).append(" |");
            result.append("\n");
            result.append(this.row.toString());
            result.append(" |");
            String v = this.checked ? checkedIndicator : uncheckedIndicator;
            result.append(" ").append(CheckTable.padEnd(v, columnWidth, ' ')).append(" |");
            return result.toString();
        }

        @Override
        public ImmutableSet<R> getCompleteRows() {
            if (this.checked) {
                return this.rowSet;
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<C> getCompleteColumns() {
            if (this.checked) {
                return this.columnSet;
            }
            return ImmutableSet.empty();
        }

        public ImmutableSet<R> getCheckedRows(C column) {
            return this.getCompleteRows();
        }

        public ImmutableSet<C> getCheckedColumns(R row) {
            return this.getCompleteColumns();
        }

        @Override
        public ImmutableSet<R> getRows() {
            return this.rowSet;
        }

        @Override
        public ImmutableSet<C> getColumns() {
            return this.columnSet;
        }

        @Override
        public void uncheckAll() {
            this.checked = false;
        }

        @Override
        public void uncheckRowIf(Predicate<R> rowCheckPredicate) {
            if (rowCheckPredicate.test(this.row)) {
                this.checked = false;
            }
        }

        @Override
        public void uncheckRow(R row) {
            if (!this.row.equals(row)) {
                throw new IllegalArgumentException("Invalid row: " + row);
            }
            this.checked = false;
        }

        @Override
        public void uncheckRowIfPresent(R row) {
            if (this.row.equals(row)) {
                this.checked = false;
            }
        }

        @Override
        public Iterable<R> iterateUncheckedRows(C column) {
            if (this.column.equals(column)) {
                if (this.checked) {
                    return ImmutableSet.empty();
                }
                return this.rowSet;
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateUncheckedColumns(R row) {
            if (this.row.equals(row)) {
                if (this.checked) {
                    return ImmutableSet.empty();
                }
                return this.columnSet;
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }

        @Override
        public Iterable<R> iterateCheckedRows(C column) {
            if (this.column.equals(column)) {
                if (this.checked) {
                    return this.rowSet;
                }
                return ImmutableSet.empty();
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Iterable<C> iterateCheckedColumns(R row) {
            if (this.row.equals(row)) {
                if (this.checked) {
                    return this.columnSet;
                }
                return ImmutableSet.empty();
            }
            throw new IllegalArgumentException("Invalid row: " + row);
        }
    }
}

